document.addEventListener("DOMContentLoaded", () => {
  loadUpcomingPerformances()
})

function loadUpcomingPerformances() {
  const container = document.getElementById("upcomingCardsContainer")
  if (!container) {
    console.error("Upcoming performances container not found")
    return
  }
  container.innerHTML = '<p class="loading-message">Chargement des spectacles à venir...</p>'

  fetch("api/upcoming_performances.php")
    .then((response) => {
      if (!response.ok) {
        throw new Error(`HTTP error! status: ${response.status}`)
      }
      return response.json()
    })
    .then((result) => {
      if (result.success && result.data) {
        renderUpcomingPerformanceCards(result.data)
      } else if (result.success && result.data.length === 0) {
        container.innerHTML = '<p class="empty-message">Aucun spectacle programmé à venir pour le moment.</p>'
      } else {
        container.innerHTML = `<p class="error-message page-level">Erreur: ${result.error || "Impossible de charger les spectacles."}</p>`
        console.error("Failed to load upcoming performances:", result.error)
      }
    })
    .catch((error) => {
      container.innerHTML = `<p class="error-message page-level">Erreur de connexion: ${error.message}</p>`
      console.error("Error fetching upcoming performances:", error)
    })
}

function renderUpcomingPerformanceCards(items) {
  const container = document.getElementById("upcomingCardsContainer")
  container.innerHTML = "" // Clear loading message or previous content

  if (items.length === 0) {
    container.innerHTML = '<p class="empty-message">Aucun spectacle programmé à venir pour le moment.</p>'
    return
  }

  items.forEach((item) => {
    const cardItem = document.createElement("div")
    cardItem.className = "card-item"
    cardItem.onclick = () => viewPerformance(item.performance_id)

    const posterUrl = item.poster_url || "assets/images/placeholder.jpg"
    const title = item.performance_title || "Titre inconnu"
    const avgRating = Number.parseFloat(item.avg_rating || 0).toFixed(1)
    const reviewCount = item.review_count || 0

    let nextShowDateFormatted = "Date non spécifiée"
    if (item.next_show_datetime) {
      try {
        const dateObj = new Date(item.next_show_datetime)
        nextShowDateFormatted = `Prochaine séance le ${dateObj.toLocaleDateString("fr-FR", { day: "2-digit", month: "2-digit", year: "numeric" })} à ${dateObj.toLocaleTimeString("fr-FR", { hour: "2-digit", minute: "2-digit" })}`
      } catch (e) {
        console.warn("Invalid date format for item:", item, e)
        nextShowDateFormatted = item.next_show_datetime // fallback to raw string
      }
    }

    cardItem.innerHTML = `
      <div class="card" style="background-image: url('${posterUrl}')"></div>
      <div class="card-info">
        <div class="title">${escapeHTML(title)}</div>
        <div class="upcoming-next-date">${nextShowDateFormatted}</div>
        <div class="rating">
          ★ ${avgRating} (${reviewCount})
        </div>
        <!-- On pourrait ajouter un bouton "Détails" ou "Réserver" ici si besoin -->
      </div>
    `
    container.appendChild(cardItem)
  })
}

function viewPerformance(id) {
  window.location.href = `performance.php?id=${id}`
}

function escapeHTML(str) {
  const div = document.createElement("div")
  div.appendChild(document.createTextNode(str))
  return div.innerHTML
}
